/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.game.constants;

import info.msxlaunchers.openmsx.common.NumericalEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum InputDevice implements NumericalEnum
{
    NONE(0),
    JOYSTICK(1),
    JOYSTICK_KEYBOARD(2),
    MOUSE(3),
    ARKANOID_PAD(4),
    TRACKBALL(5),
    TOUCHPAD(6);

    private final int value;
    private static List<InputDevice> valuesList;

    private InputDevice(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static InputDevice fromValue(int value) {
        int valueOrDefault = value;
        if (valueOrDefault < 0 || valueOrDefault >= InputDevice.values().length) {
            valueOrDefault = 0;
        }
        return valuesList.get(valueOrDefault);
    }

    static {
        valuesList = new ArrayList<InputDevice>(InputDevice.values().length);
        for (InputDevice genre : InputDevice.values()) {
            valuesList.add(genre);
        }
        valuesList = Collections.unmodifiableList(valuesList);
    }
}

